<!DOCTYPE html>
<!--
* PHP4 : nouveauCompteRendu.php
-->
<title>Nouveau compte-rendu</title>

<?php
include_once("entete.php");
include_once("modele/accesBDD.php");

if (isset($_POST["id"])) {
    $id = $_POST["id"];
}

$dbh = connexion();
?>
<link rel="stylesheet" type="text/css" href="./css/nouveauCompteRendu.css" />

<div id="titre">
    <h2>Nouveau compte-rendu</h2>
</div>
<form method="POST" action="verifNouveauCompteRendu.php">
    <?php
    // Check if the selectedValue parameter is set
    if (isset($_GET['selectedValue'])) {
        // Get the selected value from the parameter
        $selectedValue = $_GET['selectedValue'];

        // Query the database for medications in the selected family

        $lesMedicament1 = rechercherLesMedicament($dbh, $selectedValue);
        $ligneMedoc1 = $lesMedicament1->fetch();

        // Generate the updated options for the Medicament1 select element
        while ($ligneMedoc1) {
            $idMedic1 = $ligneMedoc1['mDepotLegal'];
            $libMedic1 = $ligneMedoc1['mNomCommercial'];
            echo "<option value='$idMedic1'>$libMedic1</option>";
            $ligneMedoc1 = $lesMedicament1->fetch();
        }

        // Stop further execution of the script
        exit;
    }
    // Check if the selectedValue parameter is set
    if (isset($_GET['selectedValue2'])) {
        // Get the selected value from the parameter
        $selectedValue2 = $_GET['selectedValue2'];

        // Query the database for medications in the selected family
        $dbh = connexion();
        $lesMedicament2 = rechercherLesMedicament($dbh, $selectedValue2);
        $ligneMedoc2 = $lesMedicament2->fetch();

        // Generate the updated options for the Medicament1 select element
        while ($ligneMedoc2) {
            $idMedic2 = $ligneMedoc2['mDepotLegal'];
            $libMedic2 = $ligneMedoc2['mNomCommercial'];
            echo "<option value='$idMedic2'>$libMedic2</option>";
            $ligneMedoc2 = $lesMedicament2->fetch();
        }

        // Stop further execution of the script
        exit;
    }



    // Check if the selectedValue parameter is set
    if (isset($_GET['selectedEchantillon'])) {
        // Get the selected value from the parameter
        $selectedEchantillon = $_GET['selectedEchantillon'];

        // Query the database for medications in the selected family
        $dbh = connexion();
        $ECHANTILLONmedicament = rechercherLesMedicament($dbh, $selectedEchantillon);
        $ligneECHANTILLONMedoc = $ECHANTILLONmedicament->fetch();

        // Generate the updated options for the Medicament1 select element
        while ($ligneECHANTILLONMedoc) {
            $idEchantillonMedic = $ligneECHANTILLONMedoc['mDepotLegal'];
            $libEchantillonMedic = $ligneECHANTILLONMedoc['mNomCommercial'];
            echo "<option value='$idEchantillonMedic'>$libEchantillonMedic</option>";
            $ligneECHANTILLONMedoc = $ECHANTILLONmedicament->fetch();
        }

        // Stop further execution of the script
        exit;
    }
    ?>
    



    <label for="listePraticien">Sélectionner le praticien visité </label>
    <select name="ldrPraticien" id="listePraticien" required>
        <optgroup label="Les praticiens">
            <?php
            $dbh = connexion();
            $regionUtilisateurSQL = rechercherRegionUtilisateur($dbh, $id);
            $regionUtilisateur = $regionUtilisateurSQL['uRegion'];
            $lesPraticiens = rechercherLesPraticiens($dbh, $regionUtilisateur);
            $unCompteRendu = $lesPraticiens->fetch(); // Lecture 1ère ligne jeu d'enregistrements 
            while ($unCompteRendu) {
                $id = $unCompteRendu['pNum'];
                $lib = $unCompteRendu['pNom'] . " " . $unCompteRendu['pPrenom'] . " - " . $unCompteRendu['pRue'] . ", " . $unCompteRendu['pCP'] . " " . $unCompteRendu['pVille'] . " (" . $unCompteRendu['pRegion'] . ")";
                echo "<option value='$id'>$lib</option>";
                $unCompteRendu = $lesPraticiens->fetch(); // Lecture suivante
            }
            ?>
        </optgroup>
    </select>

    <br>

    <div class='InfosVisite'>
        <label for="ztDate">Date et heure de la visite </label>
        <input type="datetime-local" id="ztDate" name="ztDate" required>

        <label for="motifVisite" id="motifDeLaVisite">Motif de la visite </label>
        <select name="listemotifVisite" id="motifVisite" required>
            <optgroup label="Motif de la visite :">
                <?php
                $lesMotifs = rechercherLesMotifs($dbh);
                foreach ($lesMotifs as $ligneMotif) {
                    $idMotif = $ligneMotif['pIndice'];
                    $libMotif = $ligneMotif['pLibelle'];
                    echo "<option value='$idMotif'>$libMotif</option>";
                }
                ?>
            </optgroup>
        </select>
    </div>

    <br>

    <div class='premierMedoc'>
        <div class='premierMedocFam'>
            <label for="FamilleMedicament1">Famille du 1er médicament </label>
            <select name=listeFamilleMedicament1 id="FamilleMedicament1" required>
                <optgroup label="Famille médicament 1 :">
                    <?php
                    $lesFamilles = rechercherLesFamillesMedicament($dbh);
                    $ligneFamille1 = $lesFamilles->fetch(); // Lecture 1ère ligne jeu d'enregistrements 
                    while ($ligneFamille1) {
                        $idFamMedic1 = $ligneFamille1['fCode'];
                        $libFamMedic1 = $ligneFamille1['fLibelle'];
                        echo "<option value='$idFamMedic1'>$libFamMedic1</option>";
                        $ligneFamille1 = $lesFamilles->fetch(); // Lecture suivante
                    }
                    ?>
                </optgroup>
            </select>
        </div>

        <div class='premierMedocMedoc'>
            <label for="Medicament1">1er médicament </label>
            <select name=listeMedicament1 id="Medicament1" required>
                <optgroup label="Medicament 1 :">
                    <!-- The options for this select element will be generated dynamically by the AJAX request -->
                </optgroup>
            </select>
        </div>

        <script>
            document.getElementById("FamilleMedicament1").addEventListener("change", function() {
                // Use an AJAX request to send the selected value to your PHP script and retrieve the updated options for the second select element
                var xhr = new XMLHttpRequest();
                xhr.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {
                        console.log("Server response:", this.responseText);
                        // Update the options in the second select element with the response from your PHP script
                        document.getElementById("Medicament1").innerHTML = this.responseText;
                    }
                };
                xhr.open("GET", "nouveauCompteRendu.php?selectedValue=" + document.getElementById("FamilleMedicament1").value, true);
                xhr.send();
            });
        </script>


    </div>
</div>

<br>

<div class='deuxiemeMedoc'>
    <div class='deuxiemeMedocFam'>
        <label for="FamilleMedicament2">Famille du 2eme médicament </label>
        <select name=listeFamilleMedicament2 id="FamilleMedicament2">
            <optgroup label="Famille médicament 2 :">
                <?php
                $lesFamilles = rechercherLesFamillesMedicament($dbh);
                $ligneFamille2 = $lesFamilles->fetch(); // Lecture 1ère ligne jeu d'enregistrements 
                while ($ligneFamille2) {
                    $idFamMedic2 = $ligneFamille2['fCode'];
                    $libFamMedic2 = $ligneFamille2['fLibelle'];
                    echo "<option value='$idFamMedic2'>$libFamMedic2</option>";
                    $ligneFamille2 = $lesFamilles->fetch(); // Lecture suivante
                }
                ?>
            </optgroup>
        </select>
    </div>

    <div class='deuxiemeMedocMedoc'>
        <label for="Medicament2">2ème médicament </label>
        <select name=listeMedicament2 id="Medicament2">
            <optgroup label="Medicament 2 :">
                <!-- The options for this select element will be generated dynamically by the AJAX request -->
            </optgroup>
        </select>
    </div>

    <script>
        document.getElementById("FamilleMedicament2").addEventListener("change", function() {
            // Use an AJAX request to send the selected value to your PHP script and retrieve the updated options for the second select element
            var xhr2 = new XMLHttpRequest();
            xhr2.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log("Server response:", this.responseText);
                    // Update the options in the second select element with the response from your PHP script
                    document.getElementById("Medicament2").innerHTML = this.responseText;
                }
            };
            xhr2.open("GET", "nouveauCompteRendu.php?selectedValue2=" + document.getElementById("FamilleMedicament2").value, true);
            xhr2.send();
        });
    </script>
</div>

<br />

<label for="txtRemarque">Remarque </label>
<textarea name="txtRemarque" id="txtRemarque"></textarea>
<div id='confianceDiv'>
    <p>
        <label>Confiance :</label>
        <div class='confiance'>
            <input type="radio" id="star1" id="confiance" name="confiance" value="1">
            <label for="star1">★</label>
            <input type="radio" id="star2" id="confiance" name="confiance" value="2">
            <label for="star2">★</label>
            <input type="radio" id="star3" id="confiance" name="confiance" value="3">
            <label for="star3">★</label>
            <input type="radio" id="star4" id="confiance" name="confiance" value="4">
            <label for="star4">★</label>
            <input type="radio" id="star5" id="confiance" name="confiance" value="5">
            <label for="star5">★</label>
        </div>
    </p>
</div>


<br>





<div class='Echantillon'>
    <div class='EchantillonFam'>
        <label for="FamilleEchantillon">Famille de l'échantillon</label>
        <select name="listeFamilleEchantillon" id="FamilleEchantillon">
            <optgroup label="Famille échantillon :">
                <?php
                $FamillesEchantillon = rechercherLesFamillesMedicament($dbh);
                while ($ligneFamilleEchantillon = $FamillesEchantillon->fetch()) {
                    $idFamMedicEchantillon = $ligneFamilleEchantillon['fCode'];
                    $libFamMedicEchantillon = $ligneFamilleEchantillon['fLibelle'];
                    echo "<option value='$idFamMedicEchantillon'>$libFamMedicEchantillon</option>";
                }
                ?>
            </optgroup>
        </select>
    </div>

    <div class='EchantillonMedoc'>
        <label for="EchantillonMedicament">Échantillon</label>
        <select name="listeEchantillonMedicament" id="EchantillonMedicament">
            <optgroup label="Echantillon :">
                <!-- The options for this select element will be generated dynamically by the AJAX request -->
            </optgroup>
        </select>
    </div>

    <div class='EchantillonNombre'>
        <label for="NombreEchantillon">Nombre</label>
        <select name="listeNombreEchantillon" id="NombreEchantillon">
            <option value="1">1</option>
            <option value="2">2</option>
            <option value="3">3</option>
            <option value="4">4</option>
            <option value="5">5</option>
            <option value="6">6</option>
            <option value="7">7</option>
            <option value="8">8</option>
            <option value="9">9</option>
            <option value="10">10</option>
        </select>
    </div>

    <button type="button" id="ajouterLigne" class='btn-ajouter'>Ajouter</button>
</div>

<table id="echantillonTable">
    <!-- Table header -->
    <tr>
        <th>Famille</th>
        <th>Médicament</th>
        <th>Nombre</th>
        <th>Action</th>
    </tr>
</table>

<script>
    document.getElementById("FamilleEchantillon").addEventListener("change", function() {
        // Use an AJAX request to send the selected value to your PHP script and retrieve the updated options for the second select element
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                console.log("Server response:", this.responseText);
                // Update the options in the second select element with the response from your PHP script
                document.getElementById("EchantillonMedicament").innerHTML = this.responseText;
            }
        };
        xhr.open("GET", "nouveauCompteRendu.php?selectedEchantillon=" + document.getElementById("FamilleEchantillon").value, true);
        xhr.send();
    });

    document.getElementById("ajouterLigne").addEventListener("click", function() {
        var famille = document.getElementById("FamilleEchantillon").value;
        var familleLabel = document.getElementById("FamilleEchantillon").options[document.getElementById("FamilleEchantillon").selectedIndex].text;

        // Vérifier si famille est vide
        if (famille === "") {
            famille = "0";
            familleLabel = "0"; // Remplacez par l'étiquette appropriée pour la valeur 0
        }

        var medicament = document.getElementById("EchantillonMedicament").value;
        var medicamentLabel = document.getElementById("EchantillonMedicament").options[document.getElementById("EchantillonMedicament").selectedIndex].text;
        var nombreSelect = document.getElementById("NombreEchantillon");
        var nombre = nombreSelect.value;

        // Vérifiez si la quantité est valide (entre 1 et 10)
        if (nombre >= 1 && nombre <= 10) {
            var table = document.getElementById("echantillonTable");
            var newRow = table.insertRow();

            var familleCell = newRow.insertCell();
            familleCell.innerHTML = '<input type="hidden" name="familleEchantillon[]" value="' + famille + '">' + familleLabel;
            

            var medicamentCell = newRow.insertCell();
            medicamentCell.innerHTML = '<input type="hidden" name="medicament[]" value="' + medicament + '">' + medicamentLabel;

            var nombreCell = newRow.insertCell();
            nombreCell.innerHTML = '<input type="hidden" name="nombre[]" value="' + nombre + '">' + nombre;

            var actionCell = newRow.insertCell();
            var deleteButton = document.createElement("button");
            deleteButton.innerHTML = "Supprimer";
            deleteButton.className = "btn-supprimer";
            deleteButton.addEventListener("click", function() {
                table.deleteRow(newRow.rowIndex);
            });
            actionCell.appendChild(deleteButton);
        } else {
            alert("La quantité d'échantillon doit être entre 1 et 10.");
        }
    });
</script>

</div>



<br>
<br>







<div id='boutons'>
    <input type="submit" id="envoyer" value="Valider">
    <input type="button" onclick="location.href='affichageCompteRendu.php';" value="Retour" class="btn-retour">
</div>


</form>

<div id="error-message">
            <?php
            if (isset ($_GET["msg"])) {
                $msg = $_GET["msg"];
                echo "<p>$msg</p>";
                unset($_GET["msg"]);
            }
            ?>
    </div>

</html>
